
!"Pocket Smalltalk fileout - 2003N612-22:29:48"!


!Database methodsFor: 'low-level access'!

setBackupBit
	| pad null array attributes  |

	pad := PadBuffer.
	null := CPointer null.
	
	SYSTRAP
		DmDatabaseInfo: 0
		localID: localID
		nameP: pad
		attributesP: (pad offsetBy: 32)
		versionP: null
		crDateP: (pad offsetBy: 34)
		modDateP: (pad offsetBy: 38)
		bckUpDateP: (pad offsetBy: 42)
		modNumP: (pad offsetBy: 46)
		appInfoIDP: null
		sortInfoIDP: null
		typeP: (pad offsetBy: 50)
		creatorP: (pad offsetBy: 54).
	pad wordAt: 32 put: ( ( pad wordAt: 32 ) bitOr: ##dmHdrAttrBackup) .
		
	SYSTRAP
		DmSetDatabaseInfo: 0
		localID: localID
		nameP: null
		attributesP: ( pad offsetBy: 32 ) 
		versionP: null
		crDateP: null
		modDateP: null
		bckUpDateP: null
		modNumP: null
		appInfoIDP: null
		sortInfoIDP: null
		typeP: null
		creatorP: null.! !


!Database methodsFor: 'low-level access'!

indexOfRecord: aString ifNone: aBlock
	|aRecord|
	aString isNil ifTrue:[ self error: 'Must Be  a String'].
	^( 0 to: self recordCount ) detect:[ :ea | aRecord :=( self recordAsString: ea ).
					         aRecord notNil and:[ aString = aRecord ] ] ifNone: aBlock
					! !


!Database class methodsFor: 'private'!

total
	^SYSTRAP DmNumDatabases: 0
! !


!Database class methodsFor: 'private'!

getDBLastError
	^SYSTRAP DmGetLastErr
! !


!Database class methodsFor: 'private'!

getDBList: type withCreator: creatorID
	| list |

	list := self getDBArray: type withCreator: creatorID.
	^list collect: [ : a | a at: 1. ].
! !


!Database class methodsFor: 'private'!

getDBArray: type withCreator: creatorID
	| typeVal creatorVal ptr0 ptr1 ptr2 err list |

	typeVal := self convertLongWord: type.
	creatorVal := self convertLongWord: creatorID.
	ptr0 := CPointer memPtrNew: 40.
	ptr1 := CPointer memPtrNew: 2.
	ptr2 := CPointer memPtrNew: 4.
	list := List new.

	err := SYSTRAP DmGetNextDatabaseByTypeCreator: (true asInteger bitShift: 8)
		stateInfoP: ptr0
		type: typeVal
		creator: creatorVal
		onlyLatest: 0
		cardNoP: ptr1
		dbIDP: ptr2.

	[ err = 0 ] whileTrue:[
		list add: (self getDBInfo: (ptr2 dwordAt: 0)).

		err := SYSTRAP DmGetNextDatabaseByTypeCreator: 0
			stateInfoP: ptr0
			type: typeVal
			creator: creatorVal
			onlyLatest: 0
			cardNoP: ptr1
			dbIDP: ptr2.
	].

	ptr0 free.
	ptr1 free.
	ptr2 free.

	^list.
! !


